## Installation for end users

### Linux

Download latest AppImage file of QMP3Gain. Make it executable and run. 

    chmod u+x qmp3gain-0.9.3-linux-x64.AppImage
    ./qmp3gain-0.9.3-linux-x64.AppImage

Linux installer does not contain required mp3gain backend, which must be installed separately. Unless you know how to install it, check the [verbose Linux guide](#verbose-linux-guide).
  
### Windows

  Download latest Windows installer exe of QMP3Gain. Follow the pages of the installation wizard. This installer does contain required mp3gain backend.

## Installation for developers

### Quick quide {#quick-guide-id}

    git clone git://qmp3gain.git.sourceforge.net/gitroot/qmp3gain/qmp3gain
    cd qmp3gain
    qmake
    make

Don't be surprised if the build runs into failure. Probably some dependencies are missing for the successful compilation. In this case check the proper verbose guide out!

### Verbose guide on Linux (Ubuntu 18.04) {#verbose-linux-guide}

1. Install QT SDK (at least v5.9 is required). 

    Check it out on https://www.qt.io and https://wiki.qt.io/Install_Qt_5_on_Ubuntu for more info.

        sudo apt install qt5-default
    
    Or if you want to actively work on the (fork of the) project install QT Creator IDE with its QT dependencies at once.

        sudo apt install qtcreator
        
    If in QT Creator IDE Clang code model fails to find stddef.h
    
        sudo apt install libclang-common-8-dev
    
    Additional QT libraries might be needed for a successful build.

        sudo apt install qtmultimedia5-dev qttools5-dev

2. Install mp3gain backend {#install-mp3gain-backend}

    At first try to install it from package repository of Ubuntu.

        sudo apt install mp3gain

    If the repo does not contain it, download and install that from the package repository of Ubuntu
    
        wget http://archive.ubuntu.com/ubuntu/pool/universe/m/mp3gain/mp3gain_1.6.2-2_amd64.deb
        sudo apt install ./mp3gain_1.6.2-2_amd64.deb
        
    However using Ubuntu 20.04 or Linux Mint 20.x there is an issue with it. Namely mp3gain commands may fail and result `Error reading the stream. (code 18)`. In this case install an older version of mp3gain using the following PPA

        sudo add-apt-repository ppa:sicklylife/qtgain
        sudo apt update
        sudo apt install mp3gain
        
    
3. To build the application follow the [Quick guide](#quick-guide-id). It downloads the source code and builds the application.
    
4. Run the application. After a successful build, run the generated executable file and enjoy it :)

        bin/qmp3gain

5. After successful build you may install it to local. However it is not recommended! You may mess your installed QT libraries up!

        sudo make install

   Later it can be uninstalled from local.

        sudo make uninstall

6. To generate all files for a later installation bundle.

        make deploy
    
    At first the required dependency must be downloaded and made it executable.
    
        sudo wget -c "https://github.com/probonopd/linuxdeployqt/releases/download/continuous/linuxdeployqt-continuous-x86_64.AppImage" -O /usr/local/bin/linuxdeployqt
        sudo chmod a+x /usr/local/bin/linuxdeployqt

    The generated files are stored in the `dist` directory.

    Important note: this target uses [linuxdeployqt](https://github.com/probonopd/linuxdeployqt) which is a great tool to export all (Qt and other) dependencies of the application. Because linuxdeployqt (normally) cannot be run on systems newer than the oldest Ubuntu LTS release, the build must be done on that. If creation of installer is not among your goals, inside installer/installer.pri add `-unsupported-allow-new-glibc` option to `DEPLOY_OPTIONS`. For more info check https://github.com/probonopd/linuxdeployqt/issues/340

7. To create AppImage installation bundle file which can be run individually in itself by end users.

        make installer
    
    At first the required dependency must be downloaded and made it executable.
    
        sudo wget -c "https://github.com/AppImage/AppImageKit/releases/download/continuous/appimagetool-x86_64.AppImage" -O /usr/local/bin/appimagetool
        sudo chmod a+x /usr/local/bin/appimagetool

    The generated installer file is stored in the `bin` directory. Noted that this `installer` target invokes `deploy` one.

8. Unified `README.md` markdown file can be created from different md files scattered in the project.

        make docs

    The generated markdown file is stored in the `bin` directory.

#### Create DEB package

You should run only

        make deb

but it does not work yet. For now use the more simple AppImage.

### Verbose guide on Windows (10)

1. Install QT SDK (at least v5.9 is required) 

    It can be installed from https://www.qt.io/offline-installers 

    After QT installation, usually I make a symbolic link from `mingw32-make.exe` file to `make.exe` to ease my work, eg.

        cd c:\ProgramFiles\Qt\Qt5.12.11\Tools\mingw730_64\bin
        mklink make.exe mingw32-make.exe

    If you already have a make executable from another developer tool, forget the symbolic link and use original `mingw32-make` instead of "make" later.)

2. Install Qt Installer Framework
    
    If you want to create installer later install the framework from https://download.qt.io/official_releases/qt-installer-framework/

3. Building the application

    Launch a "Qt command prompt" from the new menu item, and in the downloaded qmp3gain build folder use the following commands:

        qmake
        make

4. Install mp3gain backend

    Download and unzip mp3gain backend from the following link
https://sourceforge.net/projects/mp3gain/files/mp3gain/1.5.2/mp3gain-dos-1_5_2.zip/download

    Copy the unzipped `mp3gain.exe` file into `bin` folder beside the built `qmp3gain.exe`

5. Run the application

    After a successful build, run the generated executable file and enjoy it :)

        bin\qmp3gain.exe

6. After successful build you may install it to local. However its usage is not recommended! It does not make sense on this platform.

        sudo make install

   Later it can be uninstalled from local.

        sudo make uninstall

7. To generate all files for a later installation bundle.

        make deploy
    
    The generated files are stored in the `dist` directory.

8. To create installer bundle file which can be run individually in itself by end users.

        make installer
    
    The generated installer exe file is stored in the `bin` directory. Noted that this `installer` target invokes `deploy` one.

    Remember to copy `mp3gain.exe` into `bin` folder before runnung this target. It is supposed that the Windows installer contains the backend.

9. Unified `README.md` markdown file can be created from different md files scattered in the project.

        make docs

    The generated markdown file is stored in the `bin` directory.

